local assets =
{
	Asset("ANIM", "anim/guzhuguo.zip"),
    Asset("ATLAS", "images/inventoryimages/guzhuguo.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("guzhuguo")
    inst.AnimState:SetBuild("guzhuguo")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "guzhuguo"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/guzhuguo.xml"
    inst:AddComponent("selfstacker")
	--食物组件
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	 inst:AddComponent("edible")
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = 30
	inst.components.edible.sanityvalue = -5
    inst.components.edible.foodtype = FOODTYPE.VEGGIE

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("guzhuguo", fn, assets)